/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.block.crops;

import cloud.lemonslice.teastory.block.crops.flower.FlowerColor;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HybridizableFlowerBlock
extends FlowerBlock
implements BonemealableBlock {
    public static final EnumProperty<FlowerColor> FLOWER_COLOR = EnumProperty.m_61587_((String)"color", FlowerColor.class);
    protected static final VoxelShape SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0);

    public HybridizableFlowerBlock(BlockBehaviour.Properties pProperties) {
        super(() -> MobEffects.f_19601_, 2, pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(FLOWER_COLOR, (Comparable)((Object)FlowerColor.WHITE)));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Vec3 vec3 = pState.m_60824_(pLevel, pPos);
        return SHAPE.m_83216_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
    }

    public MapColor getMapColor(BlockState state, BlockGetter level, BlockPos pos, MapColor defaultColor) {
        return super.getMapColor(state, level, pos, defaultColor);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder.m_61104_(new Property[]{FLOWER_COLOR}));
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 100;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 60;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        if (context.m_43722_().m_41782_() && context.m_43722_().m_41784_().m_128441_("color")) {
            state = (BlockState)state.m_61124_(FLOWER_COLOR, (Comparable)((Object)FlowerColor.getFlowerColor(context.m_43722_().m_41783_().m_128461_("color"))));
        }
        if (context.m_43722_().m_41783_().m_128441_("BlockStateTag") && context.m_43722_().m_41783_().m_128469_("BlockStateTag").m_128441_("color")) {
            state = (BlockState)state.m_61124_(FLOWER_COLOR, (Comparable)((Object)FlowerColor.getFlowerColor(context.m_43722_().m_41783_().m_128469_("BlockStateTag").m_128461_("color"))));
        }
        return state;
    }

    public boolean isSameKind(Level worldIn, BlockPos pos) {
        return worldIn.m_8055_(pos).m_60713_((Block)this);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack stack = new ItemStack((ItemLike)this);
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("color", ((FlowerColor)((Object)state.m_61143_(FLOWER_COLOR))).getString());
        CompoundTag compoundtag1 = new CompoundTag();
        compoundtag1.m_128365_("BlockStateTag", (Tag)nbt);
        stack.m_41751_(compoundtag1);
        return stack;
    }

    public boolean m_7370_(LevelReader worldIn, BlockPos pos, BlockState pState, boolean pIsClient) {
        ArrayList positions = new ArrayList();
        Collections.addAll(positions, pos.m_122029_(), pos.m_122024_(), pos.m_122012_(), pos.m_122019_());
        for (BlockPos p : positions) {
            if (!worldIn.m_8055_(p).m_60795_() || !worldIn.m_8055_(p.m_7495_()).m_204336_(BlockTags.f_144274_)) continue;
            return true;
        }
        return false;
    }

    public boolean m_214167_(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        return true;
    }

    public void m_214148_(ServerLevel worldIn, RandomSource pRandom, BlockPos pos, BlockState state) {
        ArrayList growPositions = new ArrayList();
        ArrayList<BlockPos> canGrowPositions = new ArrayList<BlockPos>();
        Collections.addAll(growPositions, pos.m_122029_(), pos.m_122024_(), pos.m_122012_(), pos.m_122019_());
        for (BlockPos p : growPositions) {
            if (!worldIn.m_8055_(p).m_60795_() || worldIn.m_8055_(p.m_7495_()).m_204336_(BlockTags.f_144274_)) {
                // empty if block
            }
            canGrowPositions.add(p);
        }
        double randomD1 = Math.random();
        int growPosI = (int)(randomD1 * (double)canGrowPositions.size());
        ArrayList isHybFlowersPos = new ArrayList();
        ArrayList<BlockPos> hybFlowersPos = new ArrayList<BlockPos>();
        BlockPos growPos = (BlockPos)canGrowPositions.get(growPosI);
        Collections.addAll(isHybFlowersPos, growPos.m_122029_(), growPos.m_122024_(), growPos.m_122012_(), growPos.m_122019_());
        for (BlockPos p : isHybFlowersPos) {
            if (!this.isSameKind((Level)worldIn, p)) continue;
            hybFlowersPos.add(p);
        }
        if (hybFlowersPos.size() >= 2) {
            hybFlowersPos.remove(pos);
        }
        double randomD2 = Math.random();
        int hybPosI = (int)(randomD2 * (double)hybFlowersPos.size());
        worldIn.m_46597_(growPos, (BlockState)this.m_49966_().m_61124_(FLOWER_COLOR, (Comparable)((Object)FlowerColor.getHybColor((FlowerColor)((Object)state.m_61143_(FLOWER_COLOR)), (FlowerColor)((Object)worldIn.m_8055_((BlockPos)hybFlowersPos.get(hybPosI)).m_61143_(FLOWER_COLOR))))));
    }
}

